<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('purchase_invoice_item_variant_attribute_values', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('purchase_invoice_item_variant_id');
            $table->unsignedBigInteger('attribute_id');
            $table->unsignedBigInteger('attribute_value_id');

            $table->timestamps();

            // ✅ أسماء قيود قصيرة لتجنب خطأ MySQL: Identifier name is too long
            $table->foreign('purchase_invoice_item_variant_id', 'piivav_variant_fk')
                ->references('id')
                ->on('purchase_invoice_item_variants')
                ->cascadeOnDelete();

            $table->foreign('attribute_id', 'piivav_attr_fk')
                ->references('id')
                ->on('attributes')
                ->restrictOnDelete();

            $table->foreign('attribute_value_id', 'piivav_attrval_fk')
                ->references('id')
                ->on('attribute_values')
                ->restrictOnDelete();

            // منع تكرار نفس الخاصية/القيمة داخل نفس التفريعة
            $table->unique(
                ['purchase_invoice_item_variant_id', 'attribute_id', 'attribute_value_id'],
                'piivav_unique'
            );

            // لتحسين الاستعلامات
            $table->index(['attribute_id', 'attribute_value_id'], 'piivav_attr_attrval_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('purchase_invoice_item_variant_attribute_values');
    }
};
