<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('purchase_invoice_item_variants', function (Blueprint $table) {
            $table->id();

            // السطر الأصلي في فاتورة الشراء
            $table->unsignedBigInteger('purchase_invoice_item_id');

            /**
             * اختياري:
             * إذا أردت ربط التفريعة بمتغير فعلي من كاتالوك المنتجات (product_variants)
             * في حال كانت التفريعة فقط "خاصية/قيمة/كمية" بدون متغير كاتالوك، اتركه null.
             */
            $table->unsignedBigInteger('product_variant_id')->nullable();

            /**
             * بصمة (hash) للخيارات داخل هذه التفريعة لتسهيل المقارنة/منع التكرار المنطقي لاحقاً
             * تُحسب من attribute_value_ids (مرتبة) مثلاً sha256(json_encode(ids)).
             */
            $table->string('options_hash', 64)->nullable();

            // كمية هذه التفريعة (عدد صحيح)
            $table->integer('quantity')->default(1);

            // اختياري: ملاحظات/باركود/انتهاء تخص هذه التفريعة
            $table->string('barcode')->nullable();
            $table->date('expiry_date')->nullable();
            $table->string('notes')->nullable();

            $table->timestamps();

            // ✅ أسماء قيود قصيرة لتجنب خطأ طول اسم الـ FK في MySQL
            $table->foreign('purchase_invoice_item_id', 'piiv_item_fk')
                ->references('id')
                ->on('purchase_invoice_items')
                ->cascadeOnDelete();

            $table->foreign('product_variant_id', 'piiv_prodvar_fk')
                ->references('id')
                ->on('product_variants')
                ->nullOnDelete();

            $table->index(['purchase_invoice_item_id'], 'piiv_item_idx');
            $table->index(['options_hash'], 'piiv_hash_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('purchase_invoice_item_variants');
    }
};
