<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invoice_counters', function (Blueprint $table) {
            $table->id();

            $table->foreignId('branch_id')
                ->constrained('branches')
                ->cascadeOnDelete();

            // يبدأ من 0 → أول فاتورة = 000001
            $table->unsignedInteger('current_sequence')->default(0);

            $table->timestamps();

            // عدّاد واحد فقط لكل فرع
            $table->unique('branch_id', 'invoice_counters_branch_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoice_counters');
    }
};
