<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('product_cards', function (Blueprint $table) {
            $table->id();

            // ✅ ربط الكرت بالفرع
            $table->foreignId('branch_id')
                ->constrained('branches')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // ✅ ربط الكرت بالمستخدم (منشئ الكرت)
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            // ✅ المنتج + المتغير (اختياري)
            $table->foreignId('product_id')
                ->constrained('products')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            $table->foreignId('product_variant_id')
                ->nullable()
                ->constrained('product_variants')
                ->cascadeOnUpdate()
                ->nullOnDelete();

            // ✅ عنوان الكرت داخل Filament (الاسم الظاهر)
            $table->string('title', 120);
            $table->text('description')->nullable();
            // ✅ السعر النهائي (دينار عراقي - عدد صحيح)
            $table->unsignedInteger('price');

            // ✅ خصم (اختياري)
            $table->boolean('show_discount')->default(false);
            $table->unsignedTinyInteger('discount_percent')->nullable(); // 1..99

            // ✅ حالة الكرت
            $table->boolean('is_active')->default(true);
            $table->text('notes')->nullable();

            $table->timestamps();

            // ✅ فهارس
            $table->index(['branch_id', 'product_id']);
            $table->index(['branch_id', 'product_variant_id']);
            $table->index(['branch_id', 'user_id']);

            // ✅ منع تكرار نفس المنتج/المتغير في نفس الفرع (اختياري ومفيد)
            $table->unique(
                ['branch_id', 'product_id', 'product_variant_id'],
                'product_cards_unique_per_branch'
            );
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_cards');
    }
};
