<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('attendances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete();
            $table->foreignId('employee_id')->constrained()->cascadeOnDelete();
            $table->foreignId('work_schedule_id')->nullable()->constrained()->nullOnDelete();

            $table->dateTime('check_in');
            $table->dateTime('check_out')->nullable();
            $table->unsignedInteger('worked_minutes')->nullable();

            // إضافات للتأخير والوقت الإضافي
            $table->unsignedInteger('late_minutes')->default(0); // دقائق التأخير
            $table->unsignedInteger('overtime_minutes')->default(0); // دقائق الوقت الإضافي
            $table->boolean('overtime_approved')->default(false); // موافقة الوقت الإضافي

            $table->enum('source', ['manual', 'device', 'import'])->default('manual');
            $table->enum('status', ['pending', 'confirmed', 'rejected'])->default('confirmed');
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->index(['employee_id', 'check_in']);
            $table->index(['branch_id', 'check_in']);
            $table->index(['status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('attendances');
    }
};
