<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('work_schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete();
            $table->foreignId('employee_id')->nullable()->constrained()->nullOnDelete();

            $table->string('name')->nullable(); // صباحي، مسائي...
            $table->unsignedTinyInteger('weekday'); // 0=الأحد, 6=السبت
            $table->time('expected_start'); // 8:00 AM
            $table->time('expected_end'); // 4:00 PM
            $table->unsignedInteger('expected_minutes'); // 480 دقيقة = 8 ساعات

            // إضافات للوقت الإضافي والتأخير
            $table->unsignedInteger('grace_period_minutes')->default(15); // فترة السماح
            $table->unsignedInteger('overtime_rate_percentage')->default(150); // 150%

            $table->boolean('is_active')->default(true);
            $table->date('effective_from')->nullable();
            $table->date('effective_to')->nullable();
            $table->timestamps();

            $table->index(['branch_id', 'employee_id', 'weekday']);
            $table->index(['effective_from', 'effective_to']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('work_schedules');
    }
};
