<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('advance_installments', function (Blueprint $table) {
            $table->id();

            // الفرع (Multi-Branch)
            $table->foreignId('branch_id')
                ->constrained()
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            // السلفة الأصلية
            $table->foreignId('advance_id')
                ->constrained('employee_advances')
                ->cascadeOnDelete();

            // الراتب الذي خُصم منه
            $table->foreignId('payroll_id')
                ->constrained()
                ->cascadeOnDelete();

            // المستخدم الذي نفّذ الخصم
            $table->foreignId('user_id')
                ->constrained()
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            // مبلغ الخصم (INT)
            $table->integer('amount');

            $table->timestamps();
            $table->softDeletes();

            // ممنوع خصم نفس السلفة مرتين من نفس الراتب
            $table->unique(['advance_id', 'payroll_id']);

            // فهارس
            $table->index(['branch_id', 'advance_id']);
            $table->index(['branch_id', 'payroll_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('advance_installments');
    }
};
