<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('employee_advances', function (Blueprint $table) {
            $table->id();

            // العلاقات
            $table->foreignId('employee_id')
                ->constrained()
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            $table->foreignId('branch_id')
                ->constrained()
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            $table->foreignId('user_id')
                ->constrained()
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            // بيانات السلفة
            $table->integer('total_amount');        // مبلغ السلفة الكلي
            $table->integer('remaining_amount');    // المتبقي من السلفة

            // طريقة الخصم
            $table->enum('deduction_type', ['full', 'fixed', 'percent']);
            $table->integer('deduction_value')->nullable();
            // fixed  = مبلغ
            // percent = نسبة (مثال 10 = 10%)

            // بداية الخصم
            $table->integer('start_year');
            $table->integer('start_month');

            // الحالة
            $table->boolean('is_active')->default(true);

            // معلومات إضافية
            $table->text('notes')->nullable();

            $table->timestamps();
            $table->softDeletes();

            // فهارس
            $table->index(['employee_id', 'is_active']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('employee_advances');
    }
};
