<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->id();

            $table->foreignId('branch_id')->constrained()->cascadeOnDelete();
            $table->foreignId('payroll_run_id')->constrained('payroll_runs')->cascadeOnDelete();
            $table->foreignId('employee_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnUpdate()->restrictOnDelete();

            $table->unsignedSmallInteger('year');
            $table->unsignedTinyInteger('month');

            // Snapshot للراتب الأساسي لذلك الشهر (INT)
            $table->integer('basic_salary');

            // مجاميع (INT)
            $table->integer('total_bonus')->default(0);
            $table->integer('total_deduction')->default(0);
            $table->integer('total_advances')->default(0);
            $table->integer('net_salary');

            // حالة الصرف
            $table->boolean('is_paid')->default(false);
            $table->date('paid_at')->nullable();

            $table->timestamps();

            // موظف واحد لكل شهر
            $table->unique(['employee_id', 'year', 'month']);

            $table->index(['branch_id', 'year', 'month']);
            $table->index(['payroll_run_id', 'employee_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payrolls');
    }
};
