<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('receipt_counters', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('year')->index();
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete();
            $table->unsignedInteger('current_sequence')->default(0);
            $table->timestamps();

            $table->unique(['branch_id', 'year'], 'receipt_counters_branch_year_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('receipt_counters');
    }
};
