<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('installment_schedules', function (Blueprint $table) {
            $table->id();

            $table->foreignId('installment_plan_id')
                ->constrained('client_installment_plans')
                ->cascadeOnDelete();

            $table->unsignedInteger('sequence')->default(1);
            $table->unsignedBigInteger('amount')->default(0);

            $table->date('due_date');
            $table->enum('status', ['pending', 'paid', 'overdue', 'canceled'])->default('pending');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('installment_schedules');
    }
};
