<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('client_installment_plans', function (Blueprint $table) {
            $table->id();

            $table->foreignId('client_id')->constrained()->cascadeOnDelete();
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete();

            $table->string('invoice_type');
            $table->unsignedBigInteger('invoice_id');
            $table->string('invoice_number')->nullable();
            $table->date('invoice_date')->nullable();

            $table->unsignedBigInteger('total_amount')->default(0);
            $table->unsignedBigInteger('down_payment')->default(0);
            $table->unsignedBigInteger('financed_amount')->default(0);

            $table->unsignedInteger('installment_count')->default(1);
            $table->unsignedBigInteger('installment_amount')->default(0);

            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();

            $table->enum('status', ['active', 'completed', 'canceled'])->default('active');

            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();

            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('client_installment_plans');
    }
};
