<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('receipt_invoice_allocations', function (Blueprint $table) {
            $table->id();

            $table->foreignId('client_receipt_id')->constrained('client_receipts')->cascadeOnDelete();

            $table->string('invoice_type');
            $table->unsignedBigInteger('invoice_id')->index();
            $table->string('invoice_number')->nullable();
            $table->date('invoice_date')->nullable();

            $table->unsignedBigInteger('invoice_total')->default(0);
            $table->unsignedBigInteger('invoice_remaining_before')->default(0);
            $table->unsignedBigInteger('paid_amount')->default(0);
            $table->unsignedBigInteger('invoice_remaining_after')->default(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('receipt_invoice_allocations');
    }
};
