<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('client_receipts', function (Blueprint $table) {
            $table->id();

            // رقم الوصل والتسلسل السنوي
            $table->string('receipt_number')->unique();
            $table->unsignedInteger('year')->index();
            $table->unsignedInteger('sequence')->index();

            // الفرع والعميل
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete();
            $table->foreignId('client_id')->constrained()->cascadeOnDelete();

            // نوع الوصل: قبض من العميل / دفع للعميل
            $table->enum('receipt_type', ['collection', 'payment'])
                ->default('collection');

            // تاريخ الوصل
            $table->date('receipt_date')->index();

            // الحقول المالية
            $table->unsignedBigInteger('total_amount')->default(0);     // إجمالي قيمة الفاتورة / المبلغ المرجعي
            $table->unsignedBigInteger('total_paid')->default(0);       // المبلغ المدفوع في هذا الوصل
            $table->unsignedBigInteger('total_remaining')->default(0);  // المتبقي بعد هذا الوصل (إن أحببت استخدامه)

            // طريقة الدفع + تفاصيلها
            $table->string('payment_type')->default('cash');        // cash / pos / bank_transfer / ...
            $table->string('payment_details')->nullable();         // رقم التحويل / ملاحظات الدفع

            // ربط مرجعي (اختياري) – فاتورة، تقسيط، إلخ
            $table->string('reference_type')->nullable();
            $table->unsignedBigInteger('reference_id')->nullable();
            $table->string('reference_number')->nullable();

            // ملاحظات عامة
            $table->text('notes')->nullable();

            // المستخدم الذي أصدر الوصل
            $table->foreignId('issued_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            // حالة الوصل
            $table->enum('status', ['issued', 'canceled'])
                ->default('issued');

            $table->softDeletes();
            $table->timestamps();

            $table->index(['branch_id', 'year', 'sequence']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('client_receipts');
    }
};
