<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('client_accounts', function (Blueprint $table) {
            $table->id();

            $table->foreignId('client_id')->constrained()->cascadeOnDelete();
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete();

            $table->unsignedBigInteger('receivable_total')->default(0);
            $table->unsignedBigInteger('receivable_paid')->default(0);
            $table->unsignedBigInteger('receivable_remaining')->default(0);

            $table->unsignedBigInteger('payable_total')->default(0);
            $table->unsignedBigInteger('payable_paid')->default(0);
            $table->unsignedBigInteger('payable_remaining')->default(0);

            $table->unsignedBigInteger('client_advance')->default(0);
            $table->unsignedBigInteger('company_advance')->default(0);

            $table->timestamp('last_transaction_at')->nullable();
            $table->timestamps();

            $table->unique(['client_id', 'branch_id']);
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('client_accounts');
    }
};
