<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invoice_items', function (Blueprint $table) {
            $table->id();

            // ربط مع الفاتورة
            $table->foreignId('invoice_id')
                ->constrained('invoices')
                ->cascadeOnDelete();

            /*=====================================================
             * يحدد نوع العنصر داخل الفاتورة:
             * - product   : منتج جاهز (ready item)
             * - accessory : إكسسوار جاهز
             *====================================================*/
            $table->enum('item_type', ['product', 'accessory'])->default('product');

            /*=====================================================
             * حقول المنتجات الجاهزة (بيع جاهز من المعرض)
             *====================================================*/
            $table->foreignId('product_id')
                ->nullable()
                ->constrained('products')
                ->nullOnDelete();

            $table->foreignId('product_variant_id')
                ->nullable()
                ->constrained('product_variants')
                ->nullOnDelete();

            // سعر الوحدة
            $table->bigInteger('unit_price')->default(0);

            // الكمية
            $table->integer('quantity')->default(1);

            // إجمالي السطر
            $table->bigInteger('line_total')->default(0);

            // ملاحظات
            $table->text('notes')->nullable();

            $table->timestamps();

            // فهارس
            $table->index(['invoice_id']);
            $table->index(['item_type']);
            $table->index(['product_id', 'product_variant_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoice_items');
    }
};
