<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('product_prices', function (Blueprint $table) {
            $table->id();

            // ربط مع المنتج
            $table->foreignId('product_id')
                ->constrained('products')
                ->cascadeOnDelete();

            // سعر خاص لنسخة معينة (اختياري)
            $table->foreignId('product_variant_id')
                ->nullable()
                ->constrained('product_variants')
                ->cascadeOnDelete();

            // الهوامش (يمكن أن تبقى كنسبة/فاصلة عادية)
            $table->float('retail_margin')->default(0);
            $table->float('wholesale_margin')->default(0);
            $table->float('agent_margin')->default(0);

            // الأسعار: أعداد صحيحة (مثلاً بالدينار)
            $table->unsignedBigInteger('retail_price')->default(0);
            $table->unsignedBigInteger('wholesale_price')->default(0);
            $table->unsignedBigInteger('agent_price')->default(0);

            // حالة السجل
            $table->boolean('status')->default(1);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_prices');
    }
};
