<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('branch_warehouse', function (Blueprint $table) {
            $table->id();

            $table->foreignId('branch_id')
                ->constrained('branches')
                ->cascadeOnDelete();

            $table->foreignId('warehouse_id')
                ->constrained('warehouses')
                ->cascadeOnDelete();

            $table->boolean('is_primary')->default(true);

            // وقت الربط وقت الفتح
            $table->timestamp('assigned_at')
                ->useCurrent()
                ->comment('تاريخ ربط الفرع بالمستودع');

            // وقت إلغاء الربط (عند التغيير)
            $table->timestamp('unassigned_at')
                ->nullable()
                ->comment('تاريخ فك الربط من هذا المستودع');

            $table->timestamps();

            // منع التكرار لنفس الفرع مع نفس المستودع
            $table->unique(['branch_id', 'warehouse_id'], 'branch_warehouse_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('branch_warehouse');
    }
};
