<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('branch_client', function (Blueprint $table) {
            $table->id();

            $table->foreignId('branch_id')
                ->constrained('branches')
                ->cascadeOnDelete();

            $table->foreignId('client_id')
                ->constrained('clients')
                ->cascadeOnDelete();

            $table->unique(['branch_id', 'client_id']); // عميل لا يتكرر داخل نفس الفرع
            $table->index(['client_id', 'branch_id']);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('branch_client');
    }
};
