<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();

            // الفرع
            $table->foreignId('branch_id')
                ->constrained()
                ->cascadeOnDelete();

            // فئة المصروف
            $table->foreignId('expense_category_id')
                ->constrained('expense_categories')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            // المستخدم الذي أدخل المصروف
            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            // البيانات المالية
            $table->unsignedBigInteger('amount')->check('amount > 0');
            $table->text('description')->nullable();
            $table->timestamp('spent_at')->nullable()->index();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
