<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('expense_categories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete();
            $table->string('name');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();

            // منع تكرار الاسم داخل نفس الفرع
            $table->unique(['branch_id', 'name'], 'expense_categories_branch_name_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expense_categories');
    }
};
