<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vault_transactions', function (Blueprint $table) {
            $table->id();
            // 🔗 الخزنة
            $table->foreignId('vault_id')->constrained('vaults')->cascadeOnUpdate()->restrictOnDelete();
            // 💰 المبلغ (دائمًا موجب)
            $table->bigInteger('amount'); // د.ع
            // 📊 نوع العملية (1 = إيداع، 2 = سحب)
            $table->unsignedTinyInteger('transaction_type');
            // 🔗 المصدر (Morph) - ينشئ أعمدة + فهرس تلقائي
            $table->nullableMorphs('source'); // source_type + source_id + index
            // 📝 تفاصيل
            $table->text('description')->nullable();
            // 👤 الموظف الذي سجّل العملية
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete()->cascadeOnUpdate();
            // 📌 الرصيد بعد العملية
            $table->bigInteger('balance_after');
            $table->timestamps();
            // فهارس إضافية
            $table->index(['vault_id', 'created_at']);
            $table->index(['transaction_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vault_transactions');
    }
};
