<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('stock_movements', function (Blueprint $table) {
            $table->id();

            $table->foreignId('warehouse_id')                     // المخزن الذي تمت عليه الحركة
                ->constrained()
                ->cascadeOnDelete();

            $table->foreignId('product_variant_id')               // المتغير الذي تأثر بالحركة
                ->constrained()
                ->cascadeOnDelete();

            $table->enum('direction', ['IN', 'OUT', 'ADJ'])       // اتجاه الحركة: وارد / صادر / تسوية
                ->comment('IN: وارد | OUT: صادر | ADJ: تسوية');

            $table->string('source_type')->nullable()->index();   // اسم الكلاس الكامل للمصدر App\Models\...
            $table->unsignedBigInteger('source_id')->nullable()   // رقم السجل بالمصدر
                ->index();

            $table->integer('quantity');                          // الكمية المتحركة (موجبة أو سالبة)

            $table->bigInteger('unit_cost')->nullable();          // تكلفة الوحدة (اختياري)
            $table->bigInteger('total_cost')->nullable();         // التكلفة الكلية = quantity * unit_cost

            $table->timestamp('moved_at')->index();               // وقت تنفيذ الحركة

            $table->string('reference')->nullable();              // مرجع إضافي (رقم مستند أو رمز)
            $table->text('note')->nullable();                     // ملاحظات إضافية على الحركة

            $table->foreignId('user_id')                          // المستخدم الذي نفذ الحركة
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            $table->timestamps();                                 // created_at / updated_at

            // فهارس مركبة لسرعة الاستعلام
            $table->index(['warehouse_id', 'product_variant_id', 'moved_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('stock_movements');
    }
};
