<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('stock_balances', function (Blueprint $table) {
            $table->id();

            $table->foreignId('warehouse_id')                 // رقم المخزن
                ->constrained()
                ->cascadeOnDelete();

            $table->foreignId('product_variant_id')           // رقم المتغير
                ->constrained()
                ->cascadeOnDelete();

            $table->unsignedBigInteger('on_hand')             // الكمية المتوفرة فعلياً
                ->default(0);

            $table->unsignedBigInteger('reserved_qty')        // الكمية المحجوزة لطلبات مؤكدة
                ->default(0);

            $table->unsignedBigInteger('min_stock_level')     // الحد الأدنى للمخزون لإطلاق تنبيه
                ->default(0);

            $table->unsignedBigInteger('max_stock_level')     // الحد الأعلى المسموح به للمخزون
                ->default(0);

            $table->unsignedBigInteger('reorder_point')       // نقطة إعادة الطلب
                ->default(0);

            $table->unsignedBigInteger('reorder_quantity')    // كمية إعادة الطلب عند بلوغ الحد الأدنى
                ->default(0);

            $table->bigInteger('last_unit_cost')->nullable()  // آخر تكلفة شراء للوحدة
                ->comment('Last purchase unit cost');

            $table->timestamp('last_movement_at')->nullable() // آخر وقت تمت فيه حركة على هذا الرصيد
                ->comment('Last stock movement time');

            $table->timestamps();                             // created_at / updated_at

            // قيود وفهارس
            $table->unique(['warehouse_id', 'product_variant_id']); // رصيد واحد لكل مخزن ومتغير
            $table->index(['warehouse_id', 'product_variant_id']);  // تحسين عمليات البحث
            $table->index(['warehouse_id', 'min_stock_level'], 'idx_warehouse_min_stock'); // فحص مواد ناقصة
            $table->index('last_movement_at', 'idx_last_movement_at'); // فهرس للحركات الحديثة
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('stock_balances');
    }
};
