<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_allocations', function (Blueprint $table) {
            $table->id();

            // ارتباطات
            $table->foreignId('supplier_payment_id')->constrained('supplier_payments')->cascadeOnDelete(); // 'الدفعة التي يجري توزيعها'
            $table->foreignId('purchase_invoice_id')->constrained('purchase_invoices')->cascadeOnDelete(); // 'الفاتورة التي خُصّص لها جزء من الدفعة'

            // المبلغ المخصص
            $table->unsignedBigInteger('allocated_amount'); // 'المبلغ المخصص لهذه الفاتورة من إجمالي الدفعة'

            $table->timestamps();

            // قيد تفريد: منع تكرار التخصيص لنفس الدفعة ونفس الفاتورة
            $table->unique(['supplier_payment_id', 'purchase_invoice_id'], 'uniq_allocation_sp_pi');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_allocations');
    }
};
