<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplier_payments', function (Blueprint $table) {
            $table->id();

            // معلومات أساسية
            $table->string('payment_number')->unique(); // 'رقم سند الدفعة الفريد (مثال: PAY-2025-001)'
            $table->foreignId('supplier_id')->constrained()->restrictOnDelete(); // 'المورّد المستلم للدفعة'
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete(); // 'الفرع الذي سُجّلت فيه الدفعة'
            $table->foreignId('user_id')->constrained(); // 'المستخدم الذي سجّل الدفعة'

            // تفاصيل الدفع
            $table->date('payment_date'); // 'تاريخ تنفيذ/تسجيل الدفعة'
            $table->unsignedBigInteger('amount'); // 'قيمة الدفعة (دينار)'

            // طريقة الدفع
            $table->enum('payment_method', ['cash', 'bank_transfer', 'cheque', 'credit_card', 'other']); // 'طريقة الدفع: نقد/تحويل بنكي/شيك/بطاقة ائتمان/أخرى'
            $table->string('reference_number')->nullable(); // 'رقم مرجعي: رقم الشيك/رقم الحوالة/رقم البطاقة'

            // ملاحظات
            $table->text('notes')->nullable(); // 'ملاحظات على الدفعة'

            $table->timestamps();
            $table->softDeletes(); // 'الحذف الآمن'

            // فهارس
            $table->index(['supplier_id', 'payment_date'], 'idx_sp_supplier_date');
            $table->index('payment_method', 'idx_sp_method');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplier_payments');
    }
};
