<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplier_ledger', function (Blueprint $table) {
            $table->id();

            // ارتباطات
            $table->foreignId('supplier_id')->constrained()->cascadeOnDelete(); // 'المورّد صاحب القيد المحاسبي'
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete(); // 'الفرع الذي يتبع له هذا القيد'

            // المرجع (polymorphic) - يشير لـ: فاتورة / مرتجع / دفعة
            $table->morphs('ledgerable'); // 'ledgerable_type & ledgerable_id: قد تكون PurchaseInvoice / PurchaseReturn / SupplierPayment'

            // تفاصيل الحركة المحاسبية
            $table->date('transaction_date'); // 'تاريخ الحركة المحاسبية'
            $table->enum('type', ['purchase', 'return', 'payment', 'refund', 'adjustment']); // 'نوع الحركة: فاتورة/مرتجع/دفعة/استرداد/تسوية'
            $table->bigInteger('amount'); // 'قيمة الحركة: موجب (فاتورة) / سالب (دفعة أو مرتجع)'

            // معلومات إضافية
            $table->string('reference')->nullable(); // 'مرجع خارجي: رقم شيك/رقم تحويل/رقم وثيقة'
            $table->text('description')->nullable(); // 'وصف تفصيلي للحركة (اختياري)'
            $table->text('notes')->nullable(); // 'ملاحظات إضافية'

            $table->timestamps();

            // فهارس
            $table->index(['supplier_id', 'transaction_date'], 'idx_sl_supplier_date');
            $table->index(['branch_id', 'type'], 'idx_sl_branch_type');
            $table->index('ledgerable_type', 'idx_sl_ledgerable_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplier_ledgers');
    }
};
