<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_return_items', function (Blueprint $table) {
            $table->id();

            // ارتباطات
            $table->foreignId('purchase_return_id')->constrained()->cascadeOnDelete(); // 'رأس المرتجع المالِك لهذا السطر'
            $table->foreignId('purchase_invoice_item_id')->nullable()->constrained('purchase_invoice_items')->nullOnDelete(); // 'سطر الفاتورة الأصلي (اختياري إن كان المرتجع مرتبط بفاتورة)'
            $table->foreignId('product_variant_id')->constrained()->restrictOnDelete(); // 'نسخة المنتج المُرتجعة (SKU)'

            // معلومات الكمية
            $table->unsignedInteger('quantity_returned'); // 'الكمية المُرتجعة في هذا السطر'

            // معلومات التكلفة
            $table->unsignedBigInteger('unit_cost'); // 'تكلفة/سعر الوحدة الواحدة المعتمد لحساب قيمة المرتجع'
            $table->unsignedBigInteger('line_total'); // 'إجمالي هذا السطر = quantity_returned × unit_cost'

            // بيانات إضافية
            $table->string('batch_number')->nullable(); // 'رقم الدفعة المرتجعة (إن كان موجودا)'
            $table->text('notes')->nullable(); // 'ملاحظات خاصة بهذا الصنف المرتجع'

            $table->timestamps();

            // فهارس
            $table->index('purchase_return_id', 'idx_pri_return');
            $table->index('product_variant_id', 'idx_pri_variant');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_return_items');
    }
};
