<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_returns', function (Blueprint $table) {
            $table->id();

            // معلومات أساسية
            $table->string('return_number')->unique(); // 'رقم إشعار المرتجع الفريد (مثال: RET-2025-001)'
            $table->foreignId('purchase_invoice_id')->nullable()->constrained('purchase_invoices')->nullOnDelete(); // 'فاتورة الشراء الأصلية (اختياري - قد يكون مرتجع بدون فاتورة)'
            $table->foreignId('supplier_id')->constrained()->restrictOnDelete(); // 'المورّد المعني بالمرتجع'
            $table->foreignId('warehouse_id')->constrained()->restrictOnDelete(); // 'المستودع الذي تُخصم منه المرتجعات'
            $table->foreignId('user_id')->constrained(); // 'المستخدم الذي سجّل عملية المرتجع'

            // تاريخ
            $table->date('return_date'); // 'تاريخ تسجيل المرتجع'

            // معلومات مالية
            $table->unsignedBigInteger('total')->default(0); // 'إجمالي قيمة المرتجع (يصبح المورد مدين بها)'

            // حالات المرتجع
            $table->enum('status', ['pending', 'approved', 'completed', 'rejected'])
                ->default('pending'); // 'حالة معالجة المرتجع: معلق/موافق عليه/مكتمل/مرفوض'

            $table->enum('refund_method', ['cash', 'credit_note', 'bank_transfer', 'replacement'])
                ->nullable(); // 'طريقة الاسترداد: نقد/إشعار دائن/تحويل بنكي/استبدال'

            // ملاحظات
            $table->text('notes')->nullable(); // 'ملاحظات عامة على المرتجع (سبب الإرجاع وتفاصيله)'

            $table->timestamps();
            $table->softDeletes(); // 'الحذف الآمن'

            // فهارس
            $table->index(['supplier_id', 'status', 'return_date'], 'idx_pr_supplier_status_date');
            $table->index(['purchase_invoice_id', 'status'], 'idx_pr_invoice_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_returns');
    }
};
