<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_invoice_items', function (Blueprint $table) {
            $table->id();

            // ارتباطات
            $table->foreignId('purchase_invoice_id')->constrained()->cascadeOnDelete(); // 'الفاتورة المالِكة لهذا السطر/العنصر'
            $table->foreignId('product_variant_id')->constrained()->restrictOnDelete(); // 'نسخة المنتج (SKU) - حتى المنتج البسيط له نسخة افتراضية'

            // معلومات الكميات
            $table->unsignedInteger('quantity_ordered'); // 'الكمية المطلوبة/المذكورة في هذا السطر من الفاتورة'
            $table->unsignedInteger('quantity_received')->default(0); // 'الكمية المستلمة فعليًا والمُدخلة للمخزن'

            // معلومات التكلفة
            $table->unsignedBigInteger('unit_cost'); // 'سعر/تكلفة شراء الوحدة الواحدة (دينار)'
            $table->unsignedBigInteger('line_total'); // 'إجمالي هذا السطر = quantity_ordered × unit_cost'

            // حالة الاستلام
            $table->enum('receive_status', ['pending', 'partial', 'received'])
                ->default('pending'); // 'حالة استلام هذا السطر تحديدا: معلق/جزئي/مستلم كاملا'

            // بيانات إضافية (اختيارية)
            $table->date('expiry_date')->nullable(); // 'تاريخ انتهاء الصلاحية (للمنتجات القابلة للتلف)'
            $table->string('batch_number')->nullable(); // 'رقم الدفعة/الباتش للتتبع (أدوية، أغذية...)'
            $table->text('notes')->nullable(); // 'ملاحظات/وصف خاص بهذا السطر'

            $table->timestamps();

            // قيود التفريد والفهارس
            $table->unique(['purchase_invoice_id', 'product_variant_id', 'batch_number'], 'uniq_pii_invoice_variant_batch'); // 'منع تكرار نفس المنتج بنفس الباتش في نفس الفاتورة'
            $table->index(['purchase_invoice_id', 'receive_status'], 'idx_pii_invoice_status');
            $table->index('product_variant_id', 'idx_pii_variant');
            $table->index('batch_number', 'idx_pii_batch');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_invoice_items');
    }
};
