<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('warehouses', function (Blueprint $table) {
            $table->id();
            $table->string('name')->comment('اسم المستودع');
            $table->foreignId('city_id')->constrained('cities')->cascadeOnDelete();
            $table->boolean('is_active')->default(true)->comment('نشط/متوقف');
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete()->comment('مسؤول المستودع (اختياري)');
            $table->timestamps();
            $table->index(['city_id', 'is_active']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('warehouses');
    }
};
