<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('currencies', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code')->unique(); // مثل KWD, USD
            $table->string('symbol')->nullable(); // رمز العملة (مثل $، ₹، د.ع)
            $table->unsignedTinyInteger('decimal_places')->default(0); // عدد الخانات العشرية
            $table->string('position')->default('after'); // موقع الرمز (before / after)
            $table->boolean('is_default')->default(false); // هل هي العملة الافتراضية؟
            $table->boolean('is_active')->default(true);    // لتفعيل أو تعطيل العملة
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('currencies');
    }
};
