<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('barcodes', function (Blueprint $table) {
            $table->id();

            $table->foreignId('product_variant_id')
                ->constrained('product_variants')
                ->cascadeOnDelete();

            $table->string('code', 13)->unique();

            $table->boolean('is_primary')->default(false);

            $table->enum('source', ['internal', 'vendor', 'manufacturer'])
                ->default('internal')
                ->comment('internal=داخلي | vendor=مورد | manufacturer=مصنع');

            $table->boolean('is_active')->default(true);

            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            $table->timestamps();

            // ✅ الفهارس العادية
            $table->index(['product_variant_id', 'is_primary']);
            $table->index(['product_variant_id', 'is_active']);
            $table->index('is_primary');
        });

        // ❌ حذفنا الـ Partial Index (MySQL لا يدعمه)

        // ✅ التحقق من طول الباركود
        if (DB::getDriverName() === 'mysql') {
            DB::statement('
                ALTER TABLE barcodes
                ADD CONSTRAINT check_barcode_length
                CHECK (CHAR_LENGTH(code) = 13 AND code REGEXP "^[0-9]{13}$")
            ');
        }
    }

    public function down(): void
    {
        if (DB::getDriverName() === 'mysql') {
            DB::statement('ALTER TABLE barcodes DROP CONSTRAINT IF EXISTS check_barcode_length');
        }

        Schema::dropIfExists('barcodes');
    }
};
