<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('variant_attribute_values', function (Blueprint $table) {
            $table->id();

            $table->foreignId('variant_id')
                ->constrained('product_variants')
                ->cascadeOnDelete();

            $table->foreignId('attribute_id')
                ->constrained('attributes')
                ->cascadeOnDelete();

            $table->foreignId('attribute_value_id')
                ->constrained('attribute_values')
                ->cascadeOnDelete();

            $table->timestamps();

            // لا أكثر من قيمة لنفس الخاصية على نفس النسخة
            $table->unique(['variant_id', 'attribute_id'], 'vav_variant_attr_unique');

            // لا تكرار لنفس القيمة على نفس النسخة
            $table->unique(['variant_id', 'attribute_value_id'], 'vav_variant_value_unique');

            $table->index(['variant_id', 'attribute_id', 'attribute_value_id'], 'vav_triple_index');
        });

        // FK مركّب يضمن أن attribute_value_id يخص نفس attribute_id
        Schema::table('variant_attribute_values', function (Blueprint $table) {
            $table->foreign(['attribute_id', 'attribute_value_id'], 'vav_attr_comp_fk')
                ->references(['attribute_id', 'id'])
                ->on('attribute_values')
                ->cascadeOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('variant_attribute_values');
    }
};
