<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('product_variants', function (Blueprint $table) {
            $table->id();

            $table->foreignId('product_id')
                ->constrained()
                ->cascadeOnDelete();
            $table->string('name')->nullable();
            // SKU فريد
            $table->string('sku')->unique()->nullable();
            // باركود واحد اختياري لكل نسخة (إذا عندك جدول barcodes لاحقاً ممكن تلغيه)
            $table->string('barcode')->nullable()->unique();
            // كلفة/سعر كعدد صحيح
            $table->unsignedBigInteger('cost')->default(0);
            // بصمة تركيبة القيم (لون/مقاس/…)
            $table->string('options_hash')->nullable();
            $table->boolean('is_default')->default(false);
            $table->boolean('is_active')->default(true);

            $table->timestamps();
            $table->softDeletes();

            $table->index(['product_id', 'is_active']);
            $table->index(['product_id', 'is_default']);

            // ✅ يمنع تكرار نفس options_hash لنفس المنتج (مع السماح بتكرار NULL)
            $table->unique(['product_id', 'options_hash'], 'pv_product_options_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_variants');
    }
};
