<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('attribute_values', function (Blueprint $table) {
            $table->id();

            $table->foreignId('attribute_id')
                ->constrained('attributes')
                ->cascadeOnDelete();

            $table->string('value');               // قيمة برمجية (Black, 75_inch)
            $table->string('display_value');       // تسمية ظاهرة (أسود، 75 بوصة)
            $table->string('color_code')->nullable()->comment('#RRGGBB');

            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);

            $table->timestamps();

            $table->unique(['attribute_id', 'value']); // منع تكرار قيمة داخل نفس الخاصية
            $table->index(['attribute_id', 'sort_order']);

            // فريد مركب لدعم FK مركب لاحقاً (attribute_id,id)
            $table->unique(['attribute_id', 'id'], 'attr_values_attrid_id_unique');
        });

        // تحقق من صيغة اللون (اختياري – MySQL 8+)
        if (DB::getDriverName() === 'mysql') {
            DB::statement("ALTER TABLE attribute_values
                ADD CONSTRAINT chk_attribute_values_color
                CHECK (color_code IS NULL OR color_code REGEXP '^#[0-9A-Fa-f]{6}$')");
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('attribute_values');
    }
};
