<?php

use App\Enums\ProductUnit;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();

            $table->string('name');                     // اسم المنتج
            $table->string('slug')->unique();           // الرابط الصديق
            $table->text('description')->nullable();   // وصف المنتج

            $table->foreignId('category_id')->nullable()
                ->constrained()->nullOnDelete();       // الفئة

            $table->foreignId('brand_id')->nullable()
                ->constrained()->nullOnDelete();       // الماركة

            // وحدة القياس
            $table->string('unit')->default(ProductUnit::PIECE->value);

            $table->boolean('is_variable')->default(false); // مساعد للواجهة (منتج بسيط/متعدد النسخ)
            $table->boolean('is_active')->default(true);

            $table->timestamps();
            $table->softDeletes();

            $table->index(['category_id', 'brand_id', 'is_active', 'is_variable']);

            // بحث نصي (MySQL/InnoDB)
            if (DB::getDriverName() === 'mysql') {
                $table->fullText(['name', 'description']);
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
