<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();

            // علاقات
            $table->foreignId('branch_id')->constrained('branches')->cascadeOnDelete();
            $table->foreignId('pay_grade_id')->nullable()->constrained('pay_grades')->nullOnDelete();

            // حقول أساسية
            $table->string('name');
            $table->string('phone')->nullable();
            $table->string('job_title')->nullable();
            $table->text('address')->nullable();

            // خيارات
            $table->enum('gender', ['male', 'female'])->nullable();
            $table->date('hired_at')->nullable();
            $table->enum('salary_type', ['monthly', 'daily']);

            $table->boolean('is_active')->default(true);

            $table->timestamps();

            // فهارس مفيدة
            $table->index(['branch_id', 'is_active']);
            $table->index(['pay_grade_id']);
            $table->index(['salary_type']);
            $table->index(['gender']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('employees');
    }
};
