<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->id();
            // المعرف الداخلي

            $table->string('name');
            // اسم العميل

            $table->string('company')->nullable();
            // اسم الشركة (اختياري)

            $table->string('phone')->unique();
            // رقم الهاتف (فريد لتسجيل الدخول)

            $table->string('phone2')->nullable();
            // هاتف إضافي
            $table->string('client_type')->default('personal'); // نوع العميل: personal / company
            $table->foreignId('city_id')->nullable()->constrained()->nullOnDelete();
            // المدينة

            $table->text('address')->nullable();
            // عنوان عام (اختياري)

            $table->foreignId('branch_id')->constrained()->cascadeOnDelete();
            // الفرع

            $table->string('password');
            // كلمة المرور (تُخزن hash)

            $table->rememberToken();
            // تذكر تسجيل الدخول

            $table->boolean('is_active')->default(true);
            // نشط/غير نشط

            $table->timestamps();
            // created_at / updated_at
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('clients');
    }
};
