<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pay_grades', function (Blueprint $table) {
            $table->id();
            $table->string('name');         // اسم الدرجة/المسمى: محاسب، عامل خدمات...
            $table->integer('amount');      // الراتب الشهري بالدينار
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete(); // تعدد المستأجرين
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->unique(['branch_id', 'name']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pay_grades');
    }
};
