<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('branch_settings', function (Blueprint $table) {
            $table->id();

            $table->foreignId('branch_id')
                ->constrained('branches')
                ->cascadeOnUpdate()
                ->cascadeOnDelete()
                ->unique(); // 1:1
            $table->string('theme_primary')->nullable();
            $table->json('theme_palette')->nullable();
            $table->string('address')->nullable();
            $table->json('phones')->nullable();
            $table->json('socials')->nullable(); // facebook / instagram / whatsapp / tiktok
            $table->json('invoice_design')->nullable();         // NEW: إعدادات تصميم الفاتورة
            $table->json('product_card_design')->nullable();    // NEW: إعدادات تصميم كارت المنتج
            $table->json('invoice_settings')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('branch_settings');
    }
};
