<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('branches', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // الاسم الأساسي للفرع
            $table->foreignId('city_id')->constrained('cities')->cascadeOnUpdate()->cascadeOnDelete(); // ربط الفرع بالمدينة
            $table->boolean('status')->default(true); // حالة الفرع: true = نشط، false = غير نشط
            $table->timestamps();
            // قيود وفهارس
            $table->unique(['city_id', 'name']);      // اسم الفرع فريد داخل نفس المدينة
            $table->index(['city_id', 'status']);     // استعلامات شائعة
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('branches');
    }
};
