<?php

namespace Database\Factories;

use App\Models\Client;
use App\Models\Sticker;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Sticker>
 */
class StickerFactory extends Factory
{
    protected $model = Sticker::class;

    /**
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'client_id' => Client::factory(),
            'name' => fake()->words(2, true),
            'description' => fake()->sentence(),
            'category' => fake()->randomElement(['زخارف', 'نصوص', 'شعارات', 'أنماط', 'رموز']),
            'status' => Sticker::STATUS_PENDING,
            'is_active' => true,
            'usage_count' => 0,
        ];
    }

    public function approved(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => Sticker::STATUS_APPROVED,
        ]);
    }

    public function rejected(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => Sticker::STATUS_REJECTED,
            'rejection_reason' => fake()->sentence(),
        ]);
    }

    public function pending(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => Sticker::STATUS_PENDING,
        ]);
    }
}
