<?php

namespace Database\Factories;

use App\Models\ShippingCompany;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<ShippingCompany>
 */
class ShippingCompanyFactory extends Factory
{
    protected $model = ShippingCompany::class;

    public function definition(): array
    {
        $companies = [
            'توصيل السريع',
            'شحن الأمين',
            'الناقل الموثوق',
            'خدمات التوصيل',
            'سريع للشحن',
        ];

        return [
            'name' => fake()->unique()->randomElement($companies),
            'code' => strtoupper(fake()->unique()->lexify('???')),
            'phone' => fake()->phoneNumber(),
            'email' => fake()->companyEmail(),
            'contact_person' => fake()->name(),
            'address' => fake()->address(),
            'notes' => fake()->optional()->sentence(),
            'is_active' => true,
        ];
    }

    /**
     * شركة غير نشطة
     */
    public function inactive(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => false,
        ]);
    }
}
