<?php

namespace Database\Factories;

use App\Models\City;
use App\Models\Client;
use App\Models\ShippingAddress;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<ShippingAddress>
 */
class ShippingAddressFactory extends Factory
{
    protected $model = ShippingAddress::class;

    public function definition(): array
    {
        return [
            'client_id' => Client::factory(),
            'city_id' => City::query()->inRandomOrder()->first()?->id ?? 1,
            'name' => fake()->name(),
            'phone' => fake()->phoneNumber(),
            'address' => fake()->address(),
            'is_default' => false,
        ];
    }

    /**
     * عنوان افتراضي
     */
    public function default(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_default' => true,
        ]);
    }
}
