<?php

namespace Database\Factories;

use App\Models\Cart;
use App\Models\CartItem;
use App\Models\ProductVariant;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<CartItem>
 */
class CartItemFactory extends Factory
{
    protected $model = CartItem::class;

    public function definition(): array
    {
        $variant = ProductVariant::query()->inRandomOrder()->first()
            ?? ProductVariant::factory()->create();

        return [
            'cart_id' => Cart::factory(),
            'product_id' => $variant->product_id,
            'product_variant_id' => $variant->id,
            'quantity' => fake()->numberBetween(1, 5),
            'unit_price' => fake()->numberBetween(5000, 100000),
        ];
    }

    /**
     * كمية محددة
     */
    public function quantity(int $quantity): static
    {
        return $this->state(fn (array $attributes) => [
            'quantity' => $quantity,
        ]);
    }
}
