<?php

namespace Database\Factories;

use App\Models\Cart;
use App\Models\Client;
use App\Models\Currency;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends Factory<Cart>
 */
class CartFactory extends Factory
{
    protected $model = Cart::class;

    public function definition(): array
    {
        return [
            'client_id' => Client::factory(),
            'session_id' => null,
            'currency_id' => Currency::query()->inRandomOrder()->first()?->id ?? 1,
            'coupon_code' => null,
            'expires_at' => now()->addDays(7),
        ];
    }

    /**
     * سلة للضيف
     */
    public function guest(): static
    {
        return $this->state(fn (array $attributes) => [
            'client_id' => null,
            'session_id' => Str::uuid()->toString(),
        ]);
    }

    /**
     * سلة منتهية الصلاحية
     */
    public function expired(): static
    {
        return $this->state(fn (array $attributes) => [
            'expires_at' => now()->subDay(),
        ]);
    }

    /**
     * سلة مع كوبون
     */
    public function withCoupon(string $code): static
    {
        return $this->state(fn (array $attributes) => [
            'coupon_code' => $code,
        ]);
    }
}
