<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Storage Driver
    |--------------------------------------------------------------------------
    | Where to store UI preferences.
    |
    | Options:
    | - 'session' (default): Preferences stored in user session (lost on logout)
    | - 'database': Preferences stored in users table (persists across sessions)
    |
    | For database storage, you must:
    | 1. Publish and run the migration: php artisan vendor:publish --tag=filament-ui-switcher-migrations
    | 2. Add HasUiPreferences trait to your User model
    | 3. Add 'ui_preferences' => 'array' to your User model's $casts
    */
    'driver' => 'database',
    /*
    |--------------------------------------------------------------------------
    | Database Column
    |--------------------------------------------------------------------------
    | Only used if driver = 'database'.
    | The column on the users table where preferences are stored as JSON.
    |
    | Default: 'ui_preferences'
    */
    'database_column' => 'ui_preferences',

    /*
    |--------------------------------------------------------------------------
    | Default Preferences
    |--------------------------------------------------------------------------
    | Default values for UI preferences.
    | Can be overridden through the settings panel.
    */
    'defaults' => [
        'font'      => 'Cairo',
        'color'     => '#6366f1',
        'layout'    => 'sidebar-collapsed',
        'font_size' => 16,
        'density'   => 'default',
    ],

    /*
    |--------------------------------------------------------------------------
    | Default Icon for Settings Panel
    |--------------------------------------------------------------------------
    | Default Icon.
    */
    'icon' => 'heroicon-o-cog-6-tooth',

    /*
    |--------------------------------------------------------------------------
    | Available Fonts
    |--------------------------------------------------------------------------
    | List of Google Fonts available in the font selector.
    | All fonts must be available on Google Fonts.
    */
    'fonts' => [
        'IBM Plex Sans Arabic',
        'Noto Sans Arabic',
        'Cairo',
        'Readex Pro',
        'Tajawal',
        'Almarai',
        'Rubik',
        'Changa',
    ],


    /*
    |--------------------------------------------------------------------------
    | Custom Colors
    |--------------------------------------------------------------------------
    | Colors shown in the color picker.
    */
    'custom_colors' => [
        '#6366f1', // Indigo
        '#4f46e5', // Indigo Dark
        '#3b82f6', // Blue
        '#2563eb', // Blue Dark
        '#0ea5e9', // Sky Blue
        '#06b6d4', // Cyan
        '#14b8a6', // Teal
        '#10b981', // Emerald
        '#22c55e', // Green
        '#16a34a', // Green Dark
        '#84cc16', // Lime
        '#65a30d', // Lime Dark
        '#eab308', // Yellow
        '#facc15', // Golden Yellow
        '#f59e0b', // Amber
        '#f97316', // Orange
        '#ea580c', // Orange Dark
        '#ef4444', // Red
        '#dc2626', // Red Dark
        '#ec4899', // Pink
        '#db2777', // Pink Dark
        '#8b5cf6', // Purple
        '#7c3aed', // Purple Dark
        '#9333ea', // Violet
    ],

    /*
    |--------------------------------------------------------------------------
    | Available Layouts
    |--------------------------------------------------------------------------
    | Layout options available to users.
    |
    | Options:
    | - 'sidebar': Full sidebar with icons and labels
    | - 'sidebar-collapsed': Collapsed sidebar (icons only)
    | - 'sidebar-no-topbar': Sidebar without topbar (Filament v4.1+)
    | - 'topbar': Top navigation bar
    */
    'layouts' => [
        'sidebar',
        'sidebar-collapsed',
        'sidebar-no-topbar',
        'topbar',
    ],

    /*
    |--------------------------------------------------------------------------
    | Font Size Range
    |--------------------------------------------------------------------------
    | Min and max values for the font size slider (in pixels).
    */
    'font_size_range' => [
        'min' => 12,
        'max' => 30,
    ],
];
