<?php

return [

    /*
    |--------------------------------------------------------------------------
    | المستودع الافتراضي
    |--------------------------------------------------------------------------
    |
    | المستودع الذي سيتم استخدامه افتراضياً عند إنشاء حركات مخزنية
    | أو إضافة مخزون أولي للمنتجات الجديدة
    |
    */

    'default_warehouse_id' => env('DEFAULT_WAREHOUSE_ID', 1),

    /*
    |--------------------------------------------------------------------------
    | نظام التسعير
    |--------------------------------------------------------------------------
    |
    | إعدادات نظام التسعير الثلاثي (مفرد/جملة/وكيل)
    |
    */

    'pricing' => [
        // أنواع العملاء
        'customer_types' => [
            'retail' => [
                'name' => 'مفرد',
                'icon' => 'heroicon-o-user',
                'color' => 'success',
                'default_margin' => 25, // نسبة الربح الافتراضية %
            ],
            'wholesale' => [
                'name' => 'جملة',
                'icon' => 'heroicon-o-building-storefront',
                'color' => 'primary',
                'default_margin' => 15,
            ],
            'agent' => [
                'name' => 'وكيل',
                'icon' => 'heroicon-o-briefcase',
                'color' => 'warning',
                'default_margin' => 10,
            ],
        ],

        // العملة
        'currency' => [
            'code' => 'IQD',
            'symbol' => 'د.ع',
            'format' => '%s %v', // format: symbol value
            'decimal_separator' => '.',
            'thousand_separator' => ',',
            'precision' => 2,
            'divide_by' => 100, // لتحويل من INT إلى عشري
        ],

        // السماح بالأسعار السالبة (للخصومات)
        'allow_negative_prices' => false,

        // السماح بنسب ربح سالبة (البيع بخسارة)
        'allow_negative_margins' => false,
    ],

    /*
    |--------------------------------------------------------------------------
    | نظام المخزون
    |--------------------------------------------------------------------------
    |
    | إعدادات إدارة المخزون والحركات
    |
    */

    'inventory' => [
        // السماح بالرصيد السالب
        'allow_negative_stock' => false,

        // تحذير المخزون المنخفض
        'low_stock_threshold' => 10,

        // الحد الأدنى للرصيد الافتراضي عند الإنشاء
        'default_min_stock_level' => 5,

        // فترة صلاحية الحجز (بالأيام)
        'reservation_expiry_days' => 7,

        // تفعيل التتبع التلقائي للتكلفة
        'auto_track_cost' => true,

        // طريقة تقييم المخزون
        'costing_method' => 'fifo', // fifo, lifo, average

        // تفعيل الجرد الدوري
        'enable_periodic_audit' => true,

        // تكرار الجرد (بالأشهر)
        'audit_frequency_months' => 3,
    ],

    /*
    |--------------------------------------------------------------------------
    | الباركود
    |--------------------------------------------------------------------------
    |
    | إعدادات نظام الباركود
    |
    */

    'barcode' => [
        // نوع الباركود الافتراضي
        'default_type' => 'ean13',

        // البادئة الافتراضية للباركود المحلي
        'local_prefix' => '62',

        // السماح بالباركود المكرر (لنفس المنتج في نسخ مختلفة)
        'allow_duplicate_barcodes' => false,

        // التحقق التلقائي من صحة الباركود
        'auto_validate' => true,

        // توليد تلقائي للباركود عند عدم وجوده
        'auto_generate' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | SKU
    |--------------------------------------------------------------------------
    |
    | إعدادات نظام SKU
    |
    */

    'sku' => [
        // البادئة الافتراضية
        'default_prefix' => 'PRD',

        // الفاصل
        'separator' => '-',

        // طول رقم المنتج
        'product_number_length' => 4,

        // طول رقم النسخة
        'variant_number_length' => 3,

        // التنسيق: PREFIX-PRODUCT-VARIANT
        // مثال: PRD-0001-001
        'format' => '{prefix}{separator}{product}{separator}{variant}',

        // التوليد التلقائي
        'auto_generate' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | الإشعارات
    |--------------------------------------------------------------------------
    |
    | إعدادات الإشعارات التلقائية
    |
    */

    'notifications' => [
        // إشعار المخزون المنخفض
        'low_stock' => [
            'enabled' => true,
            'channels' => ['database', 'mail'],
            'recipients' => ['warehouse_manager', 'admin'],
        ],

        // إشعار نفاذ المخزون
        'out_of_stock' => [
            'enabled' => true,
            'channels' => ['database', 'mail', 'slack'],
            'recipients' => ['warehouse_manager', 'admin', 'purchasing'],
        ],

        // إشعار انتهاء صلاحية الحجز
        'reservation_expired' => [
            'enabled' => true,
            'channels' => ['database'],
            'recipients' => ['sales'],
        ],

        // إشعار موعد الجرد
        'audit_due' => [
            'enabled' => true,
            'channels' => ['database', 'mail'],
            'recipients' => ['warehouse_manager'],
            'days_before' => 7, // قبل الموعد بـ 7 أيام
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | التقارير
    |--------------------------------------------------------------------------
    |
    | إعدادات التقارير الافتراضية
    |
    */

    'reports' => [
        // تمكين التقارير التلقائية
        'enable_auto_reports' => true,

        // الفترة الزمنية الافتراضية
        'default_period' => 'month', // day, week, month, quarter, year

        // تصدير التقارير
        'export_formats' => ['pdf', 'excel', 'csv'],

        // الاحتفاظ بالتقارير (بالأيام)
        'keep_reports_days' => 90,

        // جدولة التقارير الدورية
        'scheduled_reports' => [
            'daily_stock_report' => [
                'enabled' => true,
                'time' => '23:00',
                'recipients' => ['warehouse_manager'],
            ],
            'weekly_sales_report' => [
                'enabled' => true,
                'day' => 'sunday',
                'time' => '09:00',
                'recipients' => ['admin', 'sales_manager'],
            ],
            'monthly_inventory_valuation' => [
                'enabled' => true,
                'day' => 1, // أول يوم من الشهر
                'time' => '08:00',
                'recipients' => ['admin', 'financial_manager'],
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | التكاملات
    |--------------------------------------------------------------------------
    |
    | إعدادات التكامل مع الأنظمة الخارجية
    |
    */

    'integrations' => [
        // التكامل مع POS
        'pos_enabled' => true,

        // التكامل مع المحاسبة
        'accounting_enabled' => false,

        // التكامل مع التجارة الإلكترونية
        'ecommerce_enabled' => false,

        // API Keys (يُفضل استخدام .env)
        'api_keys' => [
            // 'service_name' => env('SERVICE_API_KEY'),
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | الأداء والتخزين المؤقت
    |--------------------------------------------------------------------------
    */

    'performance' => [
        // تفعيل التخزين المؤقت للاستعلامات
        'enable_query_cache' => true,

        // مدة التخزين المؤقت (بالدقائق)
        'cache_duration' => 60,

        // تفعيل Eager Loading التلقائي
        'auto_eager_load' => true,

        // العلاقات المحملة تلقائياً
        'default_eager_load' => [
            'product' => ['category', 'brand', 'variants'],
            'variant' => ['product', 'attributeValues.attribute', 'barcodes'],
            'stock_balance' => ['warehouse', 'variant.product'],
        ],
    ],

];
