<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'store' => \App\Http\Middleware\TrackClientSession::class,
            'client.guest.redirect' => \App\Http\Middleware\RedirectIfClientAuthenticated::class,
        ]);

        $middleware->redirectGuestsTo(fn () => route('client.login'));
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
